///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the camera-related exported structures.
 *	\file		FLX_AddCamera.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_ADDCAMERA_H__
#define __FLX_ADDCAMERA_H__

	//! The camera information class.
	class CameraDescriptor : public ObjectDescriptor
	{
		public:
		// Constructor / Destructor
										CameraDescriptor();
		virtual							~CameraDescriptor();

		// Parameters
						bool			mOrthoCam;				//!< Camera type: ortographic (true) or perspective (false)
						float			mFOV;					//!< Field-Of-View (degrees) or Width for ortho cams		[Animatable]
						float			mNearClip;				//!< Near/hither clip										[Animatable]
						float			mFarClip;				//!< Far/yon clip											[Animatable]
						float			mTDist;					//!< Distance to target										[Animatable]
						long			mHLineDisplay;			//!< Horizon Line Display
						float			mEnvNearRange;			//!< Environment near range									[Animatable]
						float			mEnvFarRange;			//!< Environment far range									[Animatable]
						long			mEnvDisplay;			//!< Environment display
						long			mManualClip;			//!< Manual clip
	};

#endif // __FLX_ADDCAMERA_H__
